###############################################################
# R code: Exercise 9.2(b)
# File: MAVASplot.r
# Coded by: Brant Deppa
#
# Plots of AVAS transformation results.  
#
# INPUT:
# xmat = Matrix (e.g. Xactual) containing the independent  
#        variables. Note: p > 1 independent variables.
# y    = Vector (e.g. Yactual) with the response variable. 
# x    = List (e.g. avasout) containing 10 components. 
###############################################################
mavasplot = function(xmat,y,x,nrow=2,ncol=2){
  par(mfrow=c(nrow,ncol),ask=T)
  for (i in 1:ncol(xmat)){
      plot(xmat[,i],x$tx[,i],xlab=dimnames(xmat)[[2]][i], 
          ylab="Transformed x",pch=20,col="red")
      rug(xmat[,i])
  }
  plot(y,x$ty,xlab="y",ylab="transformed y",cex=0.7,pch=20,col="blue")
    fit <- rep(0,length(y))
    for (k in 1:ncol(xmat)){
        fit <- fit+x$tx[,k]
    }
    plot(fit, x$ty,main="Plot of Transformed y vs. Fit", 
      xlab="Fit",ylab="Transformed y ",pch=20,col="blue")
    r <- x$ty-fit
    plot(fit,r,xlab="tx",ylab="residuals",sub="Residuals vs. 
    Fit",pch=20,col="red")
    abline(h=0,col="black",lty=2)
    par(mfrow=c(1,1),ask=F)
    invisible()
}